local glocation "<place directory for your clean data>"

*******************************
*ANALYSIS
*******************************
use "`glocation'\sihloan2004_2018.dta", replace


g mortgage = (loanpurpose<5)
drop if loanpurpose == 0 
g personal = (loanpurpose > 4)

replace intrate = intrate/100 
replace intrate = . if intrate == 0 
replace mpayment = mpayment*52  
replace dinc = dinc*52 

replace startyear = . if startyear == 0 
g pduration = year-startyear 
replace pduration = . if pduration > 30 

replace term = term/12 if year == 2004 
replace term = 25 if year > 2004 

*drop term 
*g term = 25 

g factor = (1-1/(1+intrate)^term)/intrate
g spayment = origloan/factor 

g pfactor = ((1+intrate)^term - (1+intrate)^pduration)/((1+intrate)^term -1)
g schedule = origloan*pfactor 
replace schedule = 0 if schedule < 0 
g buffer = schedule-hdebt 
replace buffer = 0 if buffer < 0


g mintpay = intrate*hdebt 
g mprincipal = spayment-mintpay 
replace mprinc = . if mprinc < 0

g investor = (loanpurpose == 2)

*Not estimated for 2008 
g liqasset = bonds+loans+shares+deposits 
replace liqasset = liqasset+offset 
replace liqasset = liqasset+buffer  

g liqratio = liqasset/dinc 
g spayratio = spayment/dinc 
g mprincratio = mprinc/dinc 
g mintratio = mintpay/dinc 
g bufratio = buffer/dinc 
g hpratio = hprice/dinc 
g hdebtratio = hdebt/dinc 

g ldinc = log(dinc)


**************
*Merging aggregate lending rates based on year of loan birth
rename year year1
rename startyear year 
merge m:1 year using "`glocation'\lendingrates.dta" ,nogen keep(match master)
rename year startyear 
rename year1 year 

g cintrate = intrate-vlendingrate_new_disc  

************
*OUTLIERS
************
 
drop if intrate > 0.5 
drop if bufratio > 10 
drop if bufratio < 0 

******************* 
*MAIN REGRESSIONS
******************* 

************************
*FOR REGRESSIONS IN RDP 
************************

reg bufratio cintrate if mortgage == 1 , cl(startyear)
*Can also control for mortgage debt and doesnt make a big difference
*reg bufratio cintrate ldinc hpratio hdebtratio origratio i.pduration i.agegroup if mortgage == 1 , cl(startyear)
reg bufratio cintrate ldinc hpratio i.pduration i.agegroup if mortgage == 1 , cl(startyear)
*Hold birth cohort and age of loan constant and compare two loans that have experienced different interest rates 
*This is the preferred approach to deal with downturn babies
areg bufratio cintrate ldinc hpratio i.pduration i.agegroup if mortgage == 1 , a(startyear) cl(startyear)
*Slightly stronger here...this is purely cross sectional
reg bufratio intrate ldinc hpratio i.pduration i.year i.agegroup if mortgage == 1 , cl(startyear)


******************
*FOR GRAPHS IN RDP 
******************
drop if dinc < 0
drop if mintratio > 1 & mintratio ~=.
drop if mprincratio > 1 & mprincratio ~=.
drop if liqratio > 10 &liqratio~=.

g later = (startyear > 2009)
replace later = . if startyear < 2000 

